//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Distribution of gifts (all years)
// Objective: 	Cleaning the data to allow a histogram of the distribution of
//				gifts in 2019 to be created in excel.
//
// Created: 	15/07/2021
// Modified: 	15/11/2021
//==============================================================================

**************************************
*** Loading and cleaning the data ***
**************************************

clear	// clearing the dataset

cd "XXXX"	// set the content directory

use HILDA_restricted_combined_rescaled	// importing the unconfidentialised HILDA data for waves 1-19 that includes the new weights for residents of non-private dwellings

xtset xwaveid wave	// declaring the dataset to be a panel

merge m:1 year using CPI_FY_2018, nogen

keep if oifpnta > 0				// keeping observations with a positive inheritance recorded

keep oifpnta new_hhwtrps cpi	// keeping only the inheritance variable, responding-person sample weights and the cpi variable

gen wt_oifpnta = oifpnta * new_hhwtrps	// weighting the inheritance variable by the responding-person sample weights
replace wt_oifpnta = wt_oifpnta * (100/cpi)

egen gift_band = cut(wt_oifpnta), at(0(500)25000)	// generating inheritance bands of $10 000

by gift_band, sort: egen count = count(wt_oifpnta)		// counting the number of inheritances received within each band

collapse(count) oifpnta, by(gift_band)	// collapsing the dataset to leave the number of inheritances received within each band

save Gifts_all_years.dta, replace